<?php
include('bot/jdf.php'); 
header('Content-Type: application/json');

function fetchHTML($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 15);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}

function faToEnNumber($string) {
    $faNums = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];
    $enNums = ['0','1','2','3','4','5','6','7','8','9'];
    return str_replace($faNums, $enNums, $string);
}

function extractHolidayDays($html) {
    preg_match('/<p id="monasebat1" class="monasebat-holiday">(.*?)<\/p>/su', $html, $matches);
    if (!isset($matches[1])) return [];

    $block = $matches[1];

    preg_match('/<span id="htitle00" class="holiday-title">.*?(\p{Arabic}+)\s*:/u', $block, $monthMatch);
    $monthName = trim($monthMatch[1] ?? '');

    preg_match_all('/<span class="M1">([\p{Arabic}\d]+)<\/span>/u', $block, $daysMatches);
    $days = array_map('faToEnNumber', $daysMatches[1] ?? []);

    return [$monthName, $days];
}

function convertToGregorianArray($monthName, $days) {
    $monthMap = [
        'فروردین'=>1, 'اردیبهشت'=>2, 'خرداد'=>3, 'تیر'=>4, 'مرداد'=>5, 'شهریور'=>6,
        'مهر'=>7, 'آبان'=>8, 'آذر'=>9, 'دی'=>10, 'بهمن'=>11, 'اسفند'=>12
    ];
    $monthNumber = $monthMap[$monthName] ?? null;
    if (!$monthNumber) return [];

    $shamsiYear = jdate('Y'); 

    $miladiDates = [];
    foreach ($days as $day) {
        $day = (int)$day;
        [$gy, $gm, $gd] = jalali_to_gregorian($shamsiYear, $monthNumber, $day);
        $miladiDates[] = sprintf('%04d/%02d/%02d', $gy, $gm, $gd);
    }

    return $miladiDates;
}

$html = fetchHTML('https://www.bahesab.ir/time/calendar/');
[$monthName, $days] = extractHolidayDays($html);
$miladiArray = convertToGregorianArray($monthName, $days);

echo json_encode($miladiArray, JSON_UNESCAPED_UNICODE);
