<?php

include 'config.php';
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Cell\DataType;

$sql = "SELECT * FROM `database` WHERE `buy_status` > '0'";
$result = $connect->query($sql);

$courseData = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $courses = $row['courses'];
        
        if (strpos($courses, ',') !== false) {
            $course_codes = explode(',', $courses);
        } else {
            $course_codes = [$courses];
        }
        

        foreach ($course_codes as $course_code) {
            $courseData[$course_code][] = $row;
        }
    }
}

foreach ($courseData as $course_code => $users) {

    $stmt = $connect->prepare("SELECT `course_start`, `course_name` FROM `courses` WHERE `course_code` = ?");
    $stmt->bind_param("s", $course_code);
    $stmt->execute();
    $stmt->bind_result($course_start, $course_name);
    $stmt->fetch();
    $stmt->close();


    $date = explode('.',$course_start);

    $room_link = getRoomlink($date[2],$date[1],$date[0]);

    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

    $rowNumber = 1;

    foreach ($users as $row) {
        $username = $row['national_code'];
        $password = $row['national_code'];
        $display_name = $rowNumber . ' ' . $row['full_name'] . ' ' . $row['birthday'] . ' ' . $row['province'];
        $role = 'NORMAL';

        $sheet->setCellValueExplicit('A' . $rowNumber, $username, DataType::TYPE_STRING);
        $sheet->setCellValueExplicit('B' . $rowNumber, $password, DataType::TYPE_STRING);
        $sheet->setCellValue('C' . $rowNumber, $display_name);
        $sheet->setCellValue('D' . $rowNumber, $room_link);
        $sheet->setCellValue('E' . $rowNumber, $role);

        $rowNumber++;
    }

    $writer = new Xlsx($spreadsheet);
    $filename = "output_{$course_code}.xlsx";
    $writer->save($filename);

    $answer = "✅ فایل {$filename} ساخته شد!\nاسم دوره : $course_name";
    $EFI->sendDocument([
        'chat_id'=> -1002558112378,
        'document'=> new CURLFile("$filename"),
        'caption'=> $answer,
    ]);
}

$connect->close();

















/*include 'config.php';
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Cell\DataType;

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$sql = "SELECT * FROM `database` WHERE `buy_status` > '0'";
$result = $connect->query($sql);

$rowNumber = 1; 

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {

        $username = $row['national_code'];
        $password = $row['national_code'];
        $display_name = $rowNumber . ' ' . $row['full_name'] . ' ' . $row['birthday'] . ' ' . $row['province'];
        $courses = $row['courses'];
        $course_codes = explode(',',$courses);
        $room_link = getRoomlink(20, 04, 1404);
        $role = 'NORMAL';

        $sheet->setCellValueExplicit('A' . $rowNumber, $username, DataType::TYPE_STRING);
        $sheet->setCellValueExplicit('B' . $rowNumber, $password, DataType::TYPE_STRING);
        $sheet->setCellValue('C' . $rowNumber, $display_name);
        $sheet->setCellValue('D' . $rowNumber, $room_link);
        $sheet->setCellValue('E' . $rowNumber, $role);

        $rowNumber++;
    }
}

$writer = new Xlsx($spreadsheet);
$filename = 'output.xlsx';
$writer->save($filename);

echo "✅ فایل $filename ساخته شد!";

$connect->close();*/
?>
